import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownHubunganBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownJenisHubungan extends StatefulWidget {
  String title;
  var color;
  double? fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  DropdownJenisHubungan(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _DropdownJenisHubunganState createState() => _DropdownJenisHubunganState();
}

class _DropdownJenisHubunganState extends State<DropdownJenisHubungan> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DropdownHubunganBloc>(context).add(GetDataDropdownHubungan());
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 11, right: widget.marginHorizontal, left: widget.marginHorizontal),
      child: BlocBuilder<DropdownHubunganBloc, DropdownHubunganState>(
        builder: (BuildContext context, DropdownHubunganState state){
          if(state is DropdownHubunganSuccessState) return Container(
            child: DropdownMenu(
              dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                return DropdownMenuEntry(
                    value: item,
                    label: item.nama!
                );
              }).toList(),
              inputDecorationTheme: InputDecorationTheme(
                contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
              ),
              controller: _controller,
              onSelected: (value)=> BlocProvider.of<DropdownHubunganBloc>(context).add(SelectDataDropdownHubungan(value!)),
              label: Row(
                children: [
                  Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                  SizedBox(width: 7),
                  Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                ],
              ),
              textStyle: TextStyle(fontSize: 13),
              requestFocusOnTap: true,
              width: MediaQuery.of(context).size.width-50,
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}
